<?php
/***********************************************************************************
* SCRIPT       : Xihuitl Calendar
* VERSION      : 1.0
* AUTHOR       : Ezequiel Alans Gzz.
* EMAIL        : chequelonmx@yahoo.com.mx
* WEBSITE      : http://www.ealanis.com
* DATE         : 04/13/2003
* COUNTRY      : Mxico
* COPYRIGHT    : This software is provided AS IS.
                 The author can not be held liable for any damage
                 that might arise from the use of this software.
                 Use it at your own risk.
                 All copyright notices and links to Author's website
                 MUST remain intact in the scripts and in the HTML
                 for the scripts.
* DESCRIPTION  : Calendar, Contacts and Notes
***********************************************************************************/

function formAppt($ts="",$txtName="",$txtMsg="",$type="sa",
                  $radAllDay="F",$cboStartTime="946825200",$cboDurationHrs=1,
                  $cboDurationMins=0,$radRepeat="N",$repEndDate="0-0-0",
                  $radIcon=0,$aId=0) { // save appointment - default

  $html = "<form method='POST' action='" . $_SERVER["PHP_SELF"] . "'>";
  $html .= "<table border='0' width='100%' class='tdayappts'>";
  $html .= "<tr><td colspan='2' class='aptitle'>";
  if($type=="sa") {
    $html .=  "Add Event for " . date("l, F j, Y",$ts);
  }
  else {
    $html .=  "Edit Event for " . date("l, F j, Y",$ts);
  }
  $html .= "<tr>";
  $html .= "<td width='70'>Event Name:</td>";
  $html .= "<td>";
  $html .= "<input type='text' name='txtName' value='$txtName' size='20' maxlength='70' class='text'>";
  $html .= "<hr /></td>";
  $html .= "</tr>";
  $html .= "<tr>";
  $html .= "<td>Hour:</td>";
  $html .= "<td>";
  // Allday?
  if($radAllDay == "T") {
    $html .= "<input type='radio' name='radAllDay' value='T' CHECKED />All day event.<br>";
    $html .= "<input type='radio' name='radAllDay' value='F' />Start Time: ";
  }
  else {
    $html .= "<input type='radio' name='radAllDay' value='T' />All day event.<br>";
    $html .= "<input type='radio' name='radAllDay' value='F' CHECKED />Start Time: ";
  }

  // Start Time
  $html .= "<select name='cboStartTime'>";
  for($i=0,$j=0;$i<48;$i++,$j+=30) {
      $time = mktime(24,$j,0,1,1,2000);
      $html .= "<option value='$time' ";
      if(date("Hisa",$time) == date("Hisa",$cboStartTime)) {
        $html .= "SELECTED";
      }
      $html .= ">" . date("h:i a",$time) . "</option>";
  }
  $html .= "</select><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;End Time: ";

  // Duration Hours
  $html .= "&nbsp;<select name='cboDurationHrs'>";
  for($i=0;$i<=12;$i++) {
    $html .= "<option value='$i' ";
    if($i == $cboDurationHrs) {
      $html .= "SELECTED";
    }
    $html .= ">$i hrs.</option>";
  }
  $html .= "</select>";

  // Duration Minutes
  $html .= "<select name='cboDurationMins'>";
  for($i=0;$i<60;$i+=15) {
    $html .= "<option value='$i' ";
    if($i == $cboDurationMins) {
     $html .= "SELECTED";
    }
    $html .= ">$i mins.</option>";
  }
  $html .= "</select>";
  
  $html .= "<hr /></td>";
  $html .= "</tr>";
  $html .= "<tr>";

  // Message
  $html .= "<td>Message</td>";
  $html .= "<td>";
  $html .= "<textarea name='txtMsg' rows='3' cols='30'>$txtMsg</textarea>" .
    "<br>(Max. 255 chars)";
  $html .= "<hr /></td>";
  $html .= "</tr>";
  $html .= "<tr>";
  $html .= "<td>Repeat:</td>";
  $html .= "<td>";
  
  // Repeat
  $html .= "<input type='radio' name='radRepeat' value='N' ";
  if($radRepeat == "N") {
    $html .= "CHECKED";
  }
  $html .= " /> This event does't repeat.<br />";
  $html .= "<input type='radio' name='radRepeat' value='W' ";
  if($radRepeat == "W") {
    $html .= "CHECKED";
  }
  $html .= " /> Weekly - Every " . date("l",$ts) . ".<br />";
  $html .= "<input type='radio' name='radRepeat' value='M' ";
  if($radRepeat == "M") {
    $html .= "CHECKED";
  }
  $html .= " /> Monthly - Every " . date("j",$ts) . " of the month.<br />";
  $html .= "<input type='radio' name='radRepeat' value='Y' ";
  if($radRepeat == "Y") {
    $html .= "CHECKED";
  }
  $html .= " /> Yearly - Every " . date("j of F",$ts) . ".<br />" ;
  
  // Rep Until
  list($dRuYr,$dRuMo,$dRuDa) = split("-",$repEndDate);
  $html .= "Repeat Until <br />";
  $html .= "<select name='cboRuDa'>";
  for($i=0;$i<=31;$i++) {
    $html .= "<option value='$i' ";
    if($i==$dRuDa) {
      $html .= "SELECTED";
    }
    if($i==0) {
      $html .= ">--</option>";
    }
    else {
      $html .= ">$i</option>";
    }
  }
  $html .= "</select>";
  $html .= "<select name='cboRuMo'>";
  for($i=0;$i<=12;$i++) {
    $html .= "<option value='$i' ";
    if($i==$dRuMo) {
      $html .= "SELECTED";
    }
    if($i==0) {
      $html .= ">---</option>";
    }
    else {
      $html .= ">" . date("M",mktime(0,0,0,$i,1,2000)) . "</option>";
    }
  }
  $html .= "</select>";
  if($dRuYr==0) {
    $dRuYr = "";
  }
  $html .= "<input type='text' size='4' maxlength='4' " .
    "name='txtRuYr' value='$dRuYr' />";
  $html .= "<hr /></td>";
  $html .= "</tr>";
  $html .= "<tr>";

  // Icons
  $html .= "<td>Icon:</td>";
  $html .= "<td>";
  for($i=0;$i<20;$i++) {
    if(!($i%5)) {
      $html .= "<br>";
    }
    $html .= "<input type='radio' name='radIcon' value='" . intval($i) . "' ";
    if($i == $radIcon) {
      $html .= "CHECKED";
    }
    $html .= " />";
    if($i==0) {
      $html .= "(None)<br />";
    }
    else {
      $html .= "<img src='img/icons/" . intval($i) . ".gif' alt='Icon' /> &nbsp;";
    }
  }
  $html .= "</td></tr>";
  $html .= "<tr>";
  $html .= "<td colspan='2'>" .
    "<input type='hidden' name='ts' value='$ts' />" .
    "<input type='hidden' name='o' value='$type' />" .
    "<input type='hidden' name='a' value='$aId' />" .
    "<input type='submit' name='btnSubmit' value='Submit' class='button' />" .
    "<input type='reset' name='btnReset' value='Reset' class='button' />" .
    "<input type='button' name='btnCancel' value='Cancel' class='button' " .
      "onclick=\"location.href='" . $_SERVER["PHP_SELF"] . "?ts=$ts'\" />" .
    "</td>";
  $html .= "</tr>";
  $html .= "</table>";
  $html .= "</form>";
  return $html;
}

function editAppt($aId,$ts) {
  $sql = "SELECT apName, apAllDay, " .
    "HOUR(apStartHour) AS apTimeHour, " .
    "MINUTE(apStartHour) AS apTimeMinute, " .
    "HOUR(apEndHour) AS apEndHour, " .
    "MINUTE(apEndHour) AS apEndMinute, " .
    "apText, apRepeat, apRepUntil, apIcon " .
    "FROM tblappointments WHERE apId = '$aId'";

  // Conexin
  dbcnx() or exit("Can't connect to database");

  $result = mysql_query($sql)
    or exit(msg("a","Query Error - dumptAppt" . mysql_error() . "-" . $sql));

  $html = "";
  if($row = mysql_fetch_array($result)) {
    // Formateo de las fechas necesarias
    $startTime = mktime($row["apTimeHour"],$row["apTimeMinute"],0,1,1,2000);
    $durationHrs = $row["apEndHour"] - $row["apTimeHour"];
    $durationMins = $row["apEndMinute"] - $row["apTimeMinute"];
    
    $repEndDate = $row["apRepUntil"];
    if($repEndDate == "9999-12-31") {
      $repEndDate = "0-0-0";
    }

    $html .= formAppt($ts,$row["apName"],$row["apText"],"ua",$row["apAllDay"], // ua - update appt
             $startTime,$durationHrs,$durationMins,
             $row["apRepeat"],$repEndDate,$row["apIcon"],$aId);
  }
  return $html;
}

function updAppt($txtName,$radAllDay,$cboStartTime,$cboDurationHrs,$cboDurationMins,
            $txtMsg,$radRepeat,$repEndDate,$radIcon,$aId,$ts) {

  // Limpiamos la entrada
  clean($txtName,70);
  clean($txtMsg,255);

  // Verificamos que exista un ttulo
  if($txtName == "") {
    $txtName = "Untitled";
  }

  // Start time
  $startTime = date("H:i:s",$cboStartTime);

  // Obtenemos el end hour
  $endTime = date("H:i:s",mktime(
    (date("H",$cboStartTime))+$cboDurationHrs,
    (date("i",$cboStartTime))+$cboDurationMins,
    0,1,1,2000));

  // Validamos se existe repeat para guardar o no
  // la fecha Rep Until
  if($radRepeat == "N") {
    $repEndDate = "9999-12-31";
  }
  $sql = "UPDATE tblappointments SET " .
    "apName = '$txtName', apAllDay = '$radAllDay', " .
    "apStartHour = '$startTime', apEndHour = '$endTime', apText = '$txtMsg', " .
    "apRepeat = '$radRepeat', apRepUntil = '$repEndDate', " .
    "apIcon = '$radIcon' " .
    "WHERE apId = '$aId'";

  // Conexin
  dbcnx() or exit("Can't connect to database");

  if(mysql_query($sql)) {
    $html = msg("i","The event <a href='" . $_SERVER["PHP_SELF"] .
      "?ts=$ts&o=ea&a=$aId'>$txtName</a> was updated");
  }
  else {
    $html = msg("a",mysql_error() . " - " . $sql);
  }
  return $html;
}

function addAppt($txtName,$radAllDay,$cboStartTime,$cboDurationHrs,
                 $cboDurationMins,$txtMsg,$radRepeat,$repEndDate,$radIcon,$ts) {

  // Limpiamos la entrada
  clean($txtName,70);
  clean($txtMsg,255);

  // Verificamos que exista un ttulo
  if($txtName == "") {
    $txtName = "Untitled";
  }

  // Date
  $date = date("Y-m-d",$ts);

  // Start time
  $startTime = date("H:i:s",$cboStartTime);

  // Obtenemos el end hour
  $endTime = date("H:i:s",mktime(
    (date("H",$cboStartTime))+$cboDurationHrs,
    (date("i",$cboStartTime))+$cboDurationMins,
    0,1,1,2000));

  // Validamos se existe repeat para guardar o no
  // la fecha Rep Until
  if($radRepeat == "N") {
    $repEndDate = "9999-12-31";
  }
  $sql = "INSERT INTO tblappointments(apName,apDate,apAllDay,apStartHour,apEndHour," .
    "apText,apRepeat,apRepUntil,apIcon) " .
    "VALUES('$txtName','$date','$radAllDay','$startTime','$endTime','$txtMsg'," .
    "'$radRepeat','$repEndDate','$radIcon')";
    
  // Conexin
  dbcnx() or exit("Can't connect to database");

  if(mysql_query($sql)) {
    $html = msg("i","The event <a href='" . $_SERVER["PHP_SELF"] .
      "?ts=$ts&o=ea&a=" . mysql_insert_id() . "'>$txtName</a> was added");
  }
  else {
    $html = msg("a",mysql_error() . " - " . $sql);
  }
  return $html; 
}

function delConfirm($aId,$ts) {
  $date = date("Y-m-d",$ts);
  $sql = "SELECT apName, TIME_FORMAT(apStartHour,'%h:%i %p') AS apStartTime " .
    "FROM tblappointments WHERE apId = '$aId'";

  // Conexin
  dbcnx() or exit("Can't connect to database");

  $result = mysql_query($sql)
    or exit(msg("a","Query Error - dumptAppt" . mysql_error() . "-" . $sql));

  $html = "";
  if($row = mysql_fetch_array($result)) {
    $html .= "<form method='POST' action='" . $_SERVER["PHP_SELF"] . "'>";
    $html .= "<table width='100%' >";
    $html .= "<tr>";
    $html .= "<td class='aptitle'>Delete Appointment</td>";
    $html .= "</tr><tr>";
    $html .= "<td>";
    $html .= msg("i",$row["apName"] . "<br />" . $date .
                 "<br />" . $row["apStartTime"]);
    $html .= "</td></tr><tr>";
    $html .= "<td>" .
      "<input type='hidden' name='o' value='d2' />" .
      "<input type='hidden' name='a' value='$aId' />" .
      "<input type='hidden' name='ts' value='$ts' />" .
      "<input type='submit' name='btnSubmit' value='Delete' class='button' />" .
      "<input type='button' name='btnCancel' value='Cancel' class='button' " .
        "onclick=\"location.href='" . $_SERVER["PHP_SELF"] . "?ts=$ts'\" class='button' />" .
      "</td></tr></table></form>";
  }
  return $html; 
}

function delAppt($aId,$ts) {
  $sql = "DELETE FROM tblappointments WHERE apId = '$aId'";
  
  // Conexin
  dbcnx() or exit("Can't connect to database");
  
  if(mysql_query($sql)) {
    $html = msg("i","The appointment was deleted");
  }
  else {
    $html = msg("a",mysql_error() . " - " . $sql);
  }
  return $html; 
}

function showAppts($ts) {
  $confHourFrom = 6;
  $confHourTo = 19;
  $date = date("Y-m-d",$ts);

  $sql = "SELECT apId, apDate, apName, DAYOFMONTH(apDate) AS apDay, " .
    "TIME_FORMAT(apStartHour,'%h:%i %p') AS apStartTime, HOUR(apStartHour) AS apStartHour24, " .
    "TIME_FORMAT(apEndHour,'%h:%i %p') AS apEndTime, apAllDay, apRepeat, apIcon " .
    "FROM tblappointments WHERE apDate = '$date' " .
    "OR (apRepeat = 'W' AND DAYOFWEEK(apDate) = DAYOFWEEK('$date') AND ('$date' >= apDate AND '$date' <= apRepUntil)) " .
    "OR (apRepeat = 'M' AND DAYOFMONTH(apDate) = DAYOFMONTH('$date') AND ('$date' >= apDate AND '$date' <= apRepUntil)) " .
    "OR (apRepeat = 'Y' AND (MONTH(apDate) = MONTH('$date') AND DAYOFMONTH(apDate) = DAYOFMONTH('$date')) AND ('$date' >= apDate AND '$date' <= apRepUntil)) " .
    "ORDER BY apDate, apStartHour";

  $html = "<table width='100%' border='0' class='aptitle'>";
  $html .= "<tr><td>Appointments for " . date("l, F j",$ts) . "</td></tr></table>";

  for($i=$confHourFrom;$i<$confHourTo;$i++) {

    $time = mktime($i,0,0,1,1,2000);
    $tmp = "<table width='100%' class='tdayappts'><tr>";
    $tmp .= "<td width='60'><a href='" . $_SERVER["PHP_SELF"] .
      "?ts=$ts&o=aa&ti=$time'>" . date("h:i a",$time) . "</a></td>";
    $tmp .= "<td>";
    $day[$i] = $tmp;
  }
  // Dos horarios para los appointments que no alcanzan a
  // ser visualizados
  $dayBefore = "<table width='100%' class='tt'><tr>" .
    "<td width='60'><img src='img/sun.gif' border='0' alt='Morning events' /></td><td>";
  $dayAfter = "<table width='100%' border='0' cellspacing='1' class='tt'><tr>" .
    "<td width='60'><img src='img/moon.gif' border='0' alt='Night events' /></td><td>";

  // Conexin
  dbcnx() or exit("Can't connect to database");

  $result = mysql_query($sql)
    or exit("Query Error - dumptAppt" . mysql_error() . "-" . $sql);

  if($row = mysql_fetch_array($result)) {
    do {
      $tmp = "<table width='100%' class='tdayappts'><tr>";
      $tmp .= "<td width='17'><img src='img/icons/" . $row["apIcon"] . ".gif' alt='Icon' width='17' height='17' /></td>";
      // Es un evento de todo el da?
      $tmp .= "<td><div class='thourappt'>";
      if($row["apAllDay"]=="T") {
        $tmp .= "All Day";
      }
      else {
        $tmp .= $row["apStartTime"] . " - " . $row["apEndTime"];
      }
      $tmp .= "</div>";
      $tmp .= "<a href='" . $_SERVER["PHP_SELF"] .
          "?ts=$ts&o=ea&a=" . $row["apId"] . "'>" . $row["apName"] . "</a></td>";
      $tmp .= "<td width='15'><a href='" . $_SERVER["PHP_SELF"] .
          "?ts=$ts&o=d1&a=" . $row["apId"] . "'>" .
          "<img src='img/del.gif' border='0' alt='delete' /></a></td>";
      $tmp .= "</tr></table>";
      $dHr = intval($row["apStartHour24"]);

      // Ajustamos para fechas que se salen de rango
      if($dHr<$confHourFrom) {
        $dayBefore .= $tmp;
      }
      elseif($dHr>$confHourTo) {
        $dayAfter .= $tmp;
      }
      else {
        $day[$dHr] .= $tmp;
      }
    } while($row = mysql_fetch_array($result));
  }

  // Imprimimos los appointments de antes del da
  $html .=$dayBefore . "&nbsp;</td></tr></table>";
  // Mostramos las Horas del da
  for($i=$confHourFrom;$i<$confHourTo;$i++) {
    $html .= $day[$i] . "&nbsp;</td></tr></table>";
  }
  // Imprimimos appointments despus del da
  $html .= $dayAfter . "&nbsp;</td></tr></table>";
  return $html;
}


// Funciones Extra, es parte de contacs.php
function bdaysOfMonth($mo) {
  $sql = "SELECT coId, coName, coLastName, DAYOFMONTH(coBday) AS coBday " .
    "FROM tblcontacts WHERE MONTH(coBday) = '$mo' " .
    "ORDER BY coBday";

  // Conexin
  dbcnx() or exit("Can't connect to database");

  $result = mysql_query($sql)
    or exit("Query Error - bdaysOfMonth" . mysql_error() . "-" . $sql);

  $html = "<table width='100%' border='0' cellspacing='1' class='calendar'>";
  $html .= "<tr><td class='aptitle'><img src='img/head.gif' border='0' alt='Birthdays' />" .
    "<td class='aptitle'>Birthdays of " .
    date("F",mktime(0,0,0,$mo,1,2000)) . "</td></tr></table>";

  if($row = mysql_fetch_array($result)) {
    $html .= "<table width='100%' border='0' cellspacing='1' class='calendar'>";
    $html .= "<tr><td>Day</td><td>Name</td></tr>";
    do {
      $html .= "<tr>";
      $html .= "<td class='dayNormal'>" . $row["coBday"] . "</td>";
      $html .= "<td class='dayNormal'><a href='maincon.php?o=e&c=" . $row["coId"] . "' target='contacts'>" .
        $row["coName"] . "&nbsp;" . $row["coLastName"] . "</a></td>";
      $html .= "</tr>";
    } while($row = mysql_fetch_array($result));
    $html .= "</table>";
  }
  else {
    $html .= msg("i","There are not birthdays this month");
  }
  return $html;
}
?>
