<?
/*============================================
Author :  Barand [barryaandrew@aol.com]
----------------------------------------------
Uses barand_a.txt for appointment data
and  barand_c.txt for contact data
=============================================*/
define ("AFILE","barand_a.txt");
define ("CFILE","barand_c.txt");

function getAppDays($cm) {
	global $appoints;
	$a = array();
	foreach ($appoints as $ap) {
		if ($cm == date("n",strtotime($ap['date']))) {
			$a[date("j",strtotime($ap['date']))] = 1;
		}
	}
	return $a;
}

function displayCalendar($currMonth,$currYear,$currDay) {
    $prevMonth = $currMonth==1 ? 12 : $currMonth-1;
    $nextMonth = $currMonth==12?  1 : $currMonth+1;
    $prevYear = $currMonth==1 ? $currYear-1 : $currYear;
    $nextYear = $currMonth==12? $currYear+1 : $currYear;
    
	$appdays = getAppDays($currMonth);
	
    $day1 = mktime(0,0,0,$currMonth,1,$currYear);
	$dim = date('t', $day1);
    $dayN = mktime(0,0,0,$currMonth,$dim,$currYear);
    $dow1 = (date('w',$day1)+6) % 7;
    $dowN = (date('w',$dayN)+6) % 7;
	$calHead = date('F Y',$day1);
    echo <<<EOT
		<table width="140" border="0" cellspacing="0">
        <tr>
          <td class="bl"><a class="nul" href="$_SERVER[PHP_SELF]?cy=$prevYear&cm=$prevMonth">&lt;&lt;</a></td>
          <td colspan="5" class="bl">$calHead</td>
          <td class="bl"><a class="nul" href="$_SERVER[PHP_SELF]?cy=$nextYear&cm=$nextMonth">&gt;&gt;</a></td>
        </tr>
        <tr>
          <th class="wd">M</th>
          <th class="wd">T</th>
          <th class="wd">W</th>
          <th class="wd">T</th>
          <th class="wd">F</th>
          <th class="we">S</th>
          <th class="we">S</th>
        </tr>
EOT;
	echo "<tr>";
	for ($d=0;$d<$dow1;$d++) echo "<td class=\"bl\">&nbsp;</td>";
	$c = $dow1;
	for ($d=1; $d<=$dim; $d++, $c++) {
		if ($c%7==0) echo "</tr><tr>";
		$cl = ($c%7==5 || $c%7==6) ? 'we' : 'na';
		if ($appdays[$d]) $cl .= 'p';
		echo "<td class=\"$cl\">";
		$dstr = "<a class=\"nul\" href=\"$_SERVER[PHP_SELF]?cy=$currYear&cm=$currMonth&cd=$d\">$d</a>";
		echo ($d==$currDay) ? "<B>$dstr</B>" : $dstr;
		echo "</td>";
	}
	echo "</tr></table>\n";
}

function dsort($a,$b) {
	if ($a['time']==$b['time']) return 0;
	return $a['time'] < $b['time'] ? -1 : 1;
}

function nsort($a,$b) {
	$aname = $a['lastname'].$a['firstname'];
	$bname = $b['lastname'].$b['firstname'];
	return strcmp($aname,$bname);
}

function loadApps() {
	global $appoints;
	$appoints = parse_ini_file(AFILE,true);
	uasort($appoints,'dsort');
}

function loadCons() {
	global $contacts;
	$contacts = parse_ini_file(CFILE,true);
	uasort($contacts,'nsort');
}

function writeApps() {
	global $appoints;
	ksort($appoints);
	$F = fopen(AFILE,"w");
	foreach($appoints as $id=>$app) {
		if ($app['date']) {
    		fputs($F, sprintf('[%d]%c%c',$id,13,10));
    		foreach ($app as $k=>$v) {
    			fputs($F, sprintf('%s=%s%c%c',$k,$v,13,10));
    		}
		}
	}
	fclose($F);
}

function writeCons() {
	global $contacts;
	ksort($contacts);
	$F = fopen(CFILE,"w");
	foreach($contacts as $id=>$con) {
		if ($con['firstname']||$con['lastname']) {
    		fputs($F, sprintf('[%d]%c%c',$id,13,10));
    		foreach ($con as $k=>$v) {
    			fputs($F, sprintf('%s=%s%c%c',$k,$v,13,10));
    		}
		}
	}
	fclose($F);
}

function qjOptions($m,$y) {
	echo "<option value=\"\" selected>&nbsp;</option>\n";
	for($i=1; $i<=12; $i++) {
		$t1 = date('Y-n', mktime(0,0,0,$m+$i,1,$y));
		$t2 = date('F Y', mktime(0,0,0,$m+$i,1,$y));
		echo "<option value=\"$t1\">$t2</option>\n";
	}
}

function timeOptions($t='') {
	echo "<select name=\"apptime\">";
	if ($t=='00:00') $sel = 'selected';
	echo "<option value=\"00:00\" $sel> All day</option>";
	for ($h=7;$h<24;$h++) {
		$sel = ($t==sprintf('%02d:00',$h)) ? 'selected' : '';
		echo "<option value=\"".sprintf('%02d:00',$h)."\" $sel> $h:00</option>";
		$sel = ($t==sprintf('%02d:30',$h)) ? 'selected' : '';
		echo "<option value=\"".sprintf('%02d:30',$h)."\" $sel> $h:30</option>";
	}
	echo "</select>";
}

function dfilt($i) {
	global $activeDay;
	$fd = date('Y-m-d',$activeDay);
	return $i['date']==$fd;
}

function listApps($apps,$currYear,$currMonth,$currDay) {
	$da = array_filter($apps,'dfilt');
	
	if (count($da)>0) {
    	echo "<table width=\"450\">";
    	foreach ($da as $id=>$app) {
			extract($app);
			if ($time=='00:00') $time='All day';
			if ($_GET['action']=='editapp' && $_GET['appid']==$id) {
         		$d = "<input type=\"text\" name=\"appdate\" size=\"12\" maxlength=\"12\" value=\"".date('j M y',strtotime($date))."\">";
         		$v = "<input type=\"text\" name=\"appvenue\" size=\"30\" maxlength=\"40\" value=\"$venue\">";
         		$n = "<textarea name=\"appnote\" cols=\"40\" rows=\"4\">$note</textarea>";
				echo "<form action=\"$_SERVER[PHP_SELF]\" method=\"get\">";
            	echo "<input type=\"hidden\" name=\"cy\" value=\"$currYear\">";
             	echo "<input type=\"hidden\" name=\"cm\" value=\"$currMonth\">";
             	echo "<input type=\"hidden\" name=\"cd\" value=\"$currDay\">";
             	echo "<input type=\"hidden\" name=\"appid\" value=\"$id\">";
        		echo "<tr valign=\"top\"><td class=\"na\" rowspan=\"2\">";
				timeOptions($time);
				echo "</td><td class=\"vn\">$v &nbsp;&nbsp;&nbsp; $d</td></tr>"
        		."<tr><td class=\"no\">$n<br><input type=\"submit\" name=\"action\" value=\"Save appointment\"><br></td></tr>";
          		echo "</form>";
			}
			else {
				
    			$t = "<a href=\"$_SERVER[PHP_SELF]?action=editapp&appid=$id&cy=$currYear&cm=$currMonth&cd=$currDay\">$time</a>";
        		echo "<tr valign=\"top\"><td class=\"na\" rowspan=\"2\">$t</td><td class=\"vn\">$venue</td></tr>"
        		."<tr><td class=\"no\">$note</td></tr>";
			}
    	}
    	echo "</table>";
	} else 
	echo "No appointments";
}

function buttons() {
	for($b=ord('A');$b<=ord('Z');$b++) {
	$v = chr($b);
	echo "<input type=\"submit\" name=\"search\" value=\"$v\">\n";
	}
}

function nfilt1($i) {
	global $contactFilter;
	$aname = strtoupper($i['firstname'].' '.$i['lastname']);
	return strpos($aname,strtoupper($contactFilter))!== false;
}
function nfilt2($i) {
	global $contactFilter;
	return strtoupper(substr($i['lastname'],0,1))==strtoupper($contactFilter);
}

function listContacts() {
	global $contacts,$contactFilter,$currDay,$currMonth,$currYear;
	if ($_GET['search']=='Search') {
		$contactFilter = $_GET['srch'];
		if ($contactFilter=='') $contactFilter = ' ';
		$cons = array_filter($contacts,'nfilt1');
	}
	else {
		$contactFilter = $_GET['search'];
		$cons = array_filter($contacts,'nfilt2');
	}
	echo "<table width=\"600\" bgcolor=\"#CCCC99\">";
    echo "<tr><td width=\"40%\"><b>Name</b></td><td width=\"20%\"><b>Phone</b></td><td><b>Email</b></td></tr>";
	foreach ($cons as $id=>$data) {
		extract($data);
		if (($_GET['action']=='editcon')&&($_GET['conid']==$id)) {
        echo "<form action=\"$_SERVER[PHP_SELF]\" method=\"get\">"
        	."<input type=\"hidden\" name=\"cy\" value=\"$currYear\">"
         	."<input type=\"hidden\" name=\"cm\" value=\"$currMonth\">"
         	."<input type=\"hidden\" name=\"cd\" value=\"$currDay\">"
         	."<input type=\"hidden\" name=\"conid\" value=\"$id\">"
         	."<input type=\"hidden\" name=\"srch\" value=\"{$_GET['srch']}\">"
         	."<input type=\"hidden\" name=\"search\" value=\"{$_GET['search']}\">"
        ."<tr><td width=\"40%\"><input type=\"text\" name=\"firstname\" size=\"12\" value=\"$firstname\"> <input type=\"text\" name=\"lastname\" size=\"15\" value=\"$lastname\"></td>"
        ."<td width=\"20%\"><input type=\"text\" name=\"phone\" size=\"12\" value=\"$phone\"></td><td><input type=\"text\" name=\"email\" size=\"30\" value=\"$email\"></td></tr>"
        ."<tr><td width=\"40%\">&nbsp;</td>"
        ."<td width=\"20%\">&nbsp;</td><td><input type=\"submit\" name=\"action\" value=\"Save contact\"></td></tr>"
        ."</form>";

		}
		else {
		$srch = $_GET['srch']; $search = $_GET['search'];
		echo "<tr bgcolor=\"#FFFFCC\"><td width=\"40%\"><a title=\"Edit\" href=\"$_SERVER[PHP_SELF]?srch=$srch&search=$search&action=editcon&conid=$id&cy=$currYear&cm=$currMonth&cd=$currDay\">$firstname $lastname</a></td>"
		."<td width=\"20%\">$phone</td>"
		."<td><a href=\"mailto:$email\" title=\"Send email\">$email</a></td></tr>";
		}
	}
	if (count($cons)==0) echo "<tr bgcolor=\"#FFFFCC\"><td width=\"40%\">None found</td><td width=\"20%\">&nbsp;</td><td>&nbsp;</td></tr>";
	echo "</table>";
}
/*============================================================================*/
$currMonth = $_GET['cm'] ? $_GET['cm'] : date('n');
$currYear =  $_GET['cy'] ? $_GET['cy'] : date('Y');
if ($_GET['qj']) list($currYear,$currMonth) = explode('-',$_GET['qj']);
$currDay =  $_GET['cd'] ? $_GET['cd'] : 0;
if (!$_GET) $currDay = date('j'); //default on entry
$activeDay = mktime(0,0,0,$currMonth,$currDay,$currYear);
$todayD = date('j');
$todayM  = date('n');
$todayY = date('Y');

loadApps();
loadCons();
$appchange = 0;
$conChange = 0;
switch ($action) {
case 'Add appointment':
	$newapp['date'] = date('Y-m-d',$activeDay);
	$newapp['time'] = $_GET['apptime'];
	$newapp['venue']= $_GET['appvenue'];
	$newapp['note'] = nl2br($_GET['appnote']);
	$appoints[] = $newapp;
	writeApps();
	$appchange = 1;
	break;
	
case 'Save appointment':
	if ($_GET['appdate']=='')
		$anapp['date'] = '';
	else
		$anapp['date'] = date('Y-m-d',strtotime($_GET['appdate']));
	$anapp['time'] = $_GET['apptime'];
	$anapp['venue']= $_GET['appvenue'];
	$anapp['note'] = nl2br($_GET['appnote']);
	$appoints[$_GET['appid']] = $anapp;
	writeApps();
	$appchange = 1;
	break;

case 'Add contact':
	$acon['firstname'] = $_GET['firstname'];	
	$acon['lastname'] = $_GET['lastname'];	
	$acon['phone'] = $_GET['phone'];	
	$acon['email'] = $_GET['email'];
	$contacts[] = $acon;
	writeCons();
	$_GET['search']='Search';
	$_GET['srch'] = $_GET['firstname']  . ' ' . $_GET['lastname'];
	$conchange = 1;
	break;
	
case 'Save contact':		
	$acon['firstname'] = $_GET['firstname'];	
	$acon['lastname'] = $_GET['lastname'];	
	$acon['phone'] = $_GET['phone'];	
	$acon['email'] = $_GET['email'];
	$contacts[$_GET['conid']] = $acon;
	writeCons();
	$conchange = 1;
	break;
}
if ($appchange) loadApps();
if ($conchange) loadCons();
?>
<html>
<!-- Creation date: 23/03/03 -->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>Appointments and Contacts</title>
<meta name="Author" content="Barand [barryaandrew@aol.com]">
<meta name="Generator" content="AceHTML 4 Pro">
<style type="text/css">
<!--
TH.wd {background: #99CC99; font-family: arial; font-size: 9pt; text-align: center; width: 20px; font-weight: normal}

TH.we {background: #999999; font-family: arial; font-size: 9pt; text-align: center; width: 20px; font-weight: normal}

TD.we {background: #EEEEEE; font-family: arial; font-size: 9pt; text-align: center}

TD.wep {background: #CCCCCC; font-family: arial; font-size: 9pt; text-align: center}

TD.na {background: #EEFFEE; font-family: arial; font-size: 9pt; text-align: center}

TD.nap {background: #AAFFAA; font-family: arial; font-size: 9pt; text-align: center}

TD.bl {background: #FFFFFF; font-family: arial; font-size: 9pt; text-align: center; color: #339900}

TD.no {background: #EEEEEE; font-family: arial; font-size: 9pt; text-align: left; color: #339900}

TD.vn {background: #CCCCCC; font-family: arial; font-size: 9pt; text-align: left}

A.nul {text-decoration: none}

A:hover {background: #DDDDDD; color: #FF0000}

SELECT {color: #669900; font-family: arial; font-size: 9pt}

/* End of style section. Generated by AceHTML at 25/03/03 12:22:15 */
-->
</style>
</head>
<body>
<table border="0" cellspacing="0" width="600">
  <tr>
    <td width="50%" style="background: #CCCCCC; text-align: left; color: #000000">
	<a href="<?=$_SERVER[PHP_SELF]?>?cy=<?=$todayY?>&cm=<?=$todayM?>&cd=<?=$todayD?>">Today</a> is <B><?=date('l jS F Y')?></B>
	</td>
	<td width="50%" style="background: #CCCCCC; text-align: center; color: #000000">&nbsp;</td>
  </tr>
  <tr><td>&nbsp;</td></tr>
  
</table>
<table border="0" cellspacing="0" cellpadding="5" width="600">
  <tr style="background: #FFFFCC" valign="top">
    <td width="40%" style="text-align: left">
        <form action="<?=$_SERVER[PHP_SELF]?>" method="get">
		<?displayCalendar($currMonth,$currYear,$currDay)?>
        <br>Quick jump <br><select name="qj"><?qjOptions($todayM,$todayY)?></select>&nbsp;
        		<input type="submit" value="go">	
        </form>
	</td>
    <td width="60%" class="bl" style="text-align: left; background: #FFFFCC">
	<?if ($currDay) {?>
    <p>New appointment for <?=date('l F j, Y',$activeDay)?></p>
	<form action="<?=$_SERVER[PHP_SELF]?>" method="get">
	<input type="hidden" name="cy" value="<?=$currYear?>">
 	<input type="hidden" name="cm" value="<?=$currMonth?>">
 	<input type="hidden" name="cd" value="<?=$currDay?>">
	<table border="0">
   <tr>
     <td  style="text-align: left; background: #FFFFCC">Time</td>
     <td  style="text-align: left; background: #FFFFCC"><?timeOptions()?></td>
   </tr>
   <tr>
     <td  style="text-align: left; background: #FFFFCC">With</td>
     <td  style="text-align: left; background: #FFFFCC"><input type="text" name="appvenue" size="25" maxlength="40">
                                                        </td>
   </tr>
   <tr>
     <td  style="text-align: left; background: #FFFFCC">Notes</td>
     <td  style="text-align: left; background: #FFFFCC"><textarea name="appnote" cols="22" rows="4"></textarea></td>
   </tr>
   <tr>
     <td  style="text-align: left; background: #FFFFCC">&nbsp;</td>
     <td  style="text-align: left; background: #FFFFCC"><input type="submit" name="action" value="Add appointment"></td>
   </tr>
 </table>
    </form>
	
	<?}?>
	</td>
  </tr>
</table>
<?if ($currDay) {?>
<table width="600">
	<tr valign="top">
	<td width="150"><h4><font color="#339900">Appointments</font></h4><font color="#999999"><?=date("l",$activeDay)?>
	<br><?=date("j F Y",$activeDay)?></font></td>
	<td><?listApps($appoints,$currYear,$currMonth,$currDay)?></td>
	</tr>
</table>
<?}?>
<hr width="600" align="left" size="3" color="#800000">
<table border="0" bgcolor="#CCCC99" width="600">
<form action="<?=$_SERVER[PHP_SELF]?>" method="get">
	<input type="hidden" name="cy" value="<?=$currYear?>">
 	<input type="hidden" name="cm" value="<?=$currMonth?>">
 	<input type="hidden" name="cd" value="<?=$currDay?>">
  <tr>
    <td><input type="text" name="srch" size="10" maxlength="10">
        <input type="submit" name="search" value="Search"></td>
    <td>&nbsp;</td>
        
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td colspan="3"><?buttons()?></td>
  </tr>
</form>
</table>
<?
if ($_GET['search']) {
	listContacts();
	}
?>
<table width="600" bgcolor="#CCCC99">
<tr valign="top"><td width="40%"><hr color="#800000">New contact details</td>
<td width="20%"><hr color="#800000"></td><td><hr color="#800000"></td></tr>
<tr><td width="40%"><b>Name</b></td><td width="20%"><b>Phone</b></td><td><b>Email</b></td></tr>
<form action="<?=$_SERVER[PHP_SELF]?>" method="get">
	<input type="hidden" name="cy" value="<?=$currYear?>">
 	<input type="hidden" name="cm" value="<?=$currMonth?>">
 	<input type="hidden" name="cd" value="<?=$currDay?>">
<tr><td width="40%"><input type="text" name="firstname" size="12"> <input type="text" name="lastname" size="15"></td>
<td width="20%"><input type="text" name="phone" size="12"></td><td><input type="text" name="email" size="30"></td></tr>
<tr><td width="40%">&nbsp;</td>
<td width="20%">&nbsp;</td><td><input type="submit" name="action" value="Add contact"></td></tr>
</form>
</table>
<hr width="600" align="left" color="#800000">
&nbsp;2003&nbsp;<a href="mailto:barryaandrew@aol.com?subject=Calendar & contacts">Barand</a>
</body>
</html>
