<?php
session_start( );

// read the entries to be displayed
include "PD_readEntries.php";

// return spaces, dashes and single quotes to strings
function decodeEntry( $str )
{
   $str = str_replace( "&nbsp;"," ",  $str );
	$str = str_replace(  "&ndash;","-", $str );
	$str = str_replace(  "&quot;","'", $str );
	$str = stripslashes( $str );
	$str = trim( $str );
	
	return $str;
}

session_register( 'entryType' );
$entryType = $_SESSION[ 'entryType' ];

session_register( 'entryArray' );
$entryArray = $_SESSION[ 'entryArray' ];

session_register( 'lineCount' );
$lineCount = $_SESSION[ 'lineCount' ];

if( isset( $_REQUEST[ 'page' ] ) )
{
   $pageRequested = $_REQUEST[ 'page' ];
}

else
{
   $pageRequested = 0;
}

if( is_numeric( $pageRequested ) )
{
   // requested page is already numberic, go to that page
   $page = $pageRequested;
}

else
{
   // requested page is an alpha character, converto to corresoponding page number
   // specify filename in which the user's preferences are stored
   session_register( 'usersDir' );
   $usersDir = $_SESSION[ 'usersDir' ];
   session_register( 'userName' );
   $userName = $_SESSION[ 'userName' ];
   session_register( 'dataFileName' );
   $dataFileName = $_SESSION[ 'dataFileName' ];
   $dataFile = "$usersDir/$userName/$dataFileName";

   // read the contents of the file into a single string.
   $filePointer = fopen( $dataFile, "r" );
   $fileStr = fread( $filePointer, filesize( $dataFile ) );
   fclose( $filePointer );

   $entryStr = explode( "\n", $fileStr );
	
	$maxLines = ( sizeOf( $entryStr ) - 1 );

   // using the first letter of an entries last name, find the line number in the file
   for( $lineNo = 0; $lineNo < $maxLines; ++$lineNo )
	{
	   $strLetter = substr( current( $entryStr ), 0, 1 );

	   if( ! ( strcmp( strToUpper( $pageRequested ), strToUpper( $strLetter ) ) > 0 ) )
		{
			break;
		}
      
		next( $entryStr );
	}

	$page = $lineNo - 1;
}

session_register( 'page' );
$_SESSION[ 'page' ] = $page;

// move array pointer to point to desired line number
for( $index = 0; $index < $page; ++$index )
{
	next( $entryArray );
}

// get the strings containing the field data for the left and right pages
$leftEntryLine = current( $entryArray );
next( $entryArray );
$rightEntryLine = current( $entryArray );
next( $entryArray );

session_register( 'leftEntryLine' );
$_SESSION[ 'leftEntryLine' ] = $leftEntryLine;
session_register( 'rightEntryLine' );
$_SESSION[ 'rightEntryLine' ] = $rightEntryLine;

// get the left form fields from the entry string
$lastName_l = decodeEntry( strtok( $leftEntryLine, '~' ) );
$firstName_l = decodeEntry( strtok( '~' ) );
$middleName_l = decodeEntry( strtok( '~' ) );
$address1_l = decodeEntry( strtok( '~' ) );
$address2_l = decodeEntry( strtok( '~' ) );
$city_l = decodeEntry( strtok( '~' ) );
$state_l = decodeEntry( strtok( '~' ) );
$zip_l = decodeEntry( strtok( '~' ) );
$country_l = decodeEntry( strtok( '~' ) );
$hphone_ac_l = decodeEntry( strtok( '~' ) );
$hphone_l = decodeEntry( strtok( '~' ) );
$hphone_ext_l = decodeEntry( strtok( '~' ) );
$wphone_ac_l = decodeEntry( strtok( '~' ) );
$wphone_l = decodeEntry( strtok( '~' ) );
$wphone_ext_l = decodeEntry( strtok( '~' ) );
$cphone_ac_l = decodeEntry( strtok( '~' ) );
$cphone_l = decodeEntry( strtok( '~' ) );
$notes_l = decodeEntry( strtok( '~' ) );
$emailAddress_l = decodeEntry( strtok( '~' ) );
$type_l = decodeEntry( strtok( '~' ) );

// get the right form fields from the entry string
$lastName_r = decodeEntry( strtok( $rightEntryLine, '~' ) );
$firstName_r = decodeEntry( strtok( '~' ) );
$middleName_r = decodeEntry( strtok( '~' ) );
$address1_r = decodeEntry( strtok( '~' ) );
$address2_r = decodeEntry( strtok( '~' ) );
$city_r = decodeEntry( strtok( '~' ) );
$state_r = decodeEntry( strtok( '~' ) );
$zip_r = decodeEntry( strtok( '~' ) );
$country_r = decodeEntry( strtok( '~' ) );
$hphone_ac_r = decodeEntry( strtok( '~' ) );
$hphone_r = decodeEntry( strtok( '~' ) );
$hphone_ext_r = decodeEntry( strtok( '~' ) );
$wphone_ac_r = decodeEntry( strtok( '~' ) );
$wphone_r = decodeEntry( strtok( '~' ) );
$wphone_ext_r = decodeEntry( strtok( '~' ) );
$cphone_ac_r = decodeEntry( strtok( '~' ) );
$cphone_r = decodeEntry( strtok( '~' ) );
$notes_r = decodeEntry( strtok( '~' ) );
$emailAddress_r = decodeEntry( strtok( '~' ) );
$type_r = decodeEntry( strtok( '~' ) );

$thisPage = $_SERVER[ 'PHP_SELF' ];
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

<html>
<head>
<title>Pesonal Diary - View Address Book</title>
<link rel="stylesheet" type="text/css" href="PD.css"> 

<script type="text/javascript" language="JavaScript">
<!-- hide script from older browsers

// preload images
function preload( )
{
   if( ! document.images )
   {
      return;
   }

   var ar = new Array( );
   var arguments = preload.arguments;

   for( var i = 0; i < arguments.length; i++ )
   {
      ar[ i ] = new Image( );
      ar[ i ].src = arguments[ i ];
   }
}

// change image on mouse events
function imgReset( imgBtn, newImage )
{
   imgBtn.src = newImage;

   return true;
}

// change to edit page when edit button clicked
function goEdit( btnName )
{
   if( btnName == "btn_edit_l" )
	{
	   // edit left page
      var destination = "PD_editEntry.php?page=<?php echo $page ?>";
      document.location.replace( destination );
	}
	
	else
	{
	   // edit right page
      var destination = "PD_editEntry.php?page=<?php echo ( $page + 1 ) ?>";
      document.location.replace( destination );
	}
	
   return true;	
}

// change to delete page when delete button clicked
function goDelete( btnName )
{
   if( btnName == "btn_delete_l" )
	{
	   var pwd = prompt( "Enter your password", "" );

		if( pwd != "" && pwd != null )
		{
         var destination = "PD_delEntry.php?password=" + pwd + "&lastName=<?php echo $lastName_l ?>&page=<?php echo $page ?>";

         document.location.replace( destination );
		}
		
		else
		{
		   return false;
		}
	}
	
	else
	{
	   var pwd = prompt( "Enter your password", "" );

		if( pwd != "" && pwd != null )
		{
         var destination = "PD_delEntry.php?password=" + pwd + "&lastName=<?php echo $lastName_r ?>&page=<?php echo $page ?>";

         document.location.replace( destination );
		}
		
		else
		{
		   return false;
		}
	}
}

// go to previous page when prev button clicked
function goPrev( btnName )
{
<?php
	$page = $_REQUEST[ 'page' ] - 2;

	if( $page < 0 )
	{
	   $page = 0;
	}
?>

   document.location.replace( "PD_display.php?page=<?php echo $page ?>" );
}

// go to next page when next button clicked
function goNext( )
{
<?php
	$page = $_REQUEST[ 'page' ] + 2;
	
	if( $page > ( $lineCount - 1 ) )
	{
	   $page = $lineCount - 1;
	}
?>

   document.location.replace( "PD_display.php?page=<?php echo $page ?>" );
}

// go to send page to send an email
function send_onclick( sendBtn )
{
   var address;
   var subject;
   var message;
	var destination;

   if( sendBtn.name == "leftSendBtn" )
	{
	   address = document.leftForm.leftEmail.value;
      subject = document.leftForm.leftSubject.value;
      message = document.leftForm.leftMessage.value;
		
		if( address != "" )
		{
		   destination = "PD_send.php?referrer=<?php echo $thisPage ?>&address=" + address + "&subject=" + subject + "&message=" + message + "&fname=<?php echo $firstName_l ?>" + "&lname=<?php echo $lastName_l ?>";
	   
	      location.replace( destination );
		}
		
		else
		{
         alert( "You will need to provide an e-mail address" );
		   return false;
		}
	}
	
	else
	{
	   address = document.rightForm.rightEmail.value;
      subject = document.rightForm.rightSubject.value;
      message = document.rightForm.rightMessage.value;
		
		if( address != "" )
		{
		   destination = "PD_send.php?referrer=<?php echo $thisPage ?>&address=" + address + "&subject=" + subject + "&message=" + message + "&fname=<?php echo $firstName_r ?>" + "&lname=<?php echo $lastName_r ?>";
	   
	      location.replace( destination );
		}
		
		else
		{
         alert( "You will need to provide an e-mail address" );
		   return false;
		}
	}

   return true;
}

// when user clicks inside the mail message box, clear the textarea
function message_onfocus( textBox )
{
   textBox.value = "";
}

// end hiding comment -->
</script>
</head>

<body bgcolor="#DCE9B1" onLoad="preload( 'Images/btn_edit_up.gif', 'Images/btn_edit_down.gif', 'Images/btn_prev_up.gif', 'Images/btn_prev_down.gif', 'Images/btn_next_up.gif', 'Images/btn_next_down.gif' );">
<table bgcolor="#FFFFCC" width="100%" height="100%" cellspacing="0" cellpadding="0" border="1" align="center">
  <tr align="center">
    <td width="46%">
      <table width="100%" height="100%" cellspacing="0" cellpadding="2" border="0" background="parchment.jpg">
	     <tr>
		  <td align="right">
            <table width="100%" height="100%" cellspacing="0" cellpadding="2" border="0" background="parchment.jpg">
              <tr>
                <td colspan="4" valign="middle" height="32">
			         <font size="+2"><strong><?php echo strToUpper( $lastName_l ); ?></strong></font>
                </td>
              </tr>
              <tr>
                <td colspan="2" valign="top" height="20">
					   <font size="+1"><?php echo $firstName_l; ?>&nbsp;<?php echo $middleName_l; ?></font>
                </td>
              </tr>
              <tr>
                <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
              </tr>
              <tr>
                <td colspan="4" valign="top" height="20">
					   <font size="+1"><?php echo $address1_l; ?></font>
                </td>
              </tr>
				  <?php
				  if( $address2_l != "" )
				  {
				     echo "              <tr>";
                 echo "                <td colspan='4' valign='top' height='20'>";
					  echo "                  <font size='+1'>$address2_l</font>";
                 echo "                </td>";
                 echo "              </tr>";
				  }
				  ?>
				  <tr>
                <td valign="top" height="20" colspan="2">
					   <font size="+1"><?php echo $city_l; if( $city_l != "" ) echo ","; ?>&nbsp;<?php echo $state_l; ?>&nbsp;<?php echo $zip_l; ?></font>
                </td>
              </tr>
				  <?php
				  if( $country_l != "" )
				  {
				     echo "              <tr>";
                 echo "                <td colspan='4' valign='top' height='20'>";
					  echo "                  <font size='+1'>$country_l</font>";
                 echo "                </td>";
                 echo "              </tr>";
				  }
				  ?>
              <tr>
                <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
              </tr>
				  <tr>
                <td valign="top" height="20" width="5%">
					   Home:
                </td>
                <td valign="top" height="20" colspan="3">
					   <font size="+1"><?php echo $hphone_ac_l; ?>&nbsp;<?php echo $hphone_l; ?>&nbsp;<?php if( $hphone_ext_l != "" ) echo "ext: $hphone_ext_l"; else echo "&nbsp;"; ?></font>
                </td>
              </tr>
				  <tr>
                <td valign="top" height="20" width="5%">
					   Work:
                </td>
                <td valign="top" height="20" colspan="3">
					   <font size="+1"><?php echo $wphone_ac_l; ?>&nbsp;<?php echo $wphone_l; ?>&nbsp;<?php if( $wphone_ext_l != "" ) echo "ext: $wphone_ext_l"; else echo "&nbsp;"; ?></font>
                </td>
              </tr>
				  <tr>
                <td valign="top" height="20" width="5%">
					   Cell:
                </td>
                <td valign="top" height="20" colspan="3">
					   <font size="+1"><?php echo $cphone_ac_l; ?>&nbsp;<?php echo $cphone_l; ?></font>
                </td>
              </tr>
              <tr>
                <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
              </tr>
              <tr>
                <td valign="top" height="100%" colspan="4">
                  <?php echo $notes_l; ?>
                </td>
              </tr>
              <tr>
                <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
              </tr>
            </table>
		    </td>
        </tr>
		  <tr>
          <form action="PB_display.php?page=<?php echo $page ?>" method="post" name="leftForm" id="leftForm">
		    <td height="20">
            <table width="100%" cellspacing="0" cellpadding="2" border="0" background="parchment.jpg">
              <tr>
                <td align="left" valign="bottom">
				      E-mail:
                </td>
                <td colspan="2" align="left" height="20" valign="bottom">
			      	<input type="text" name="leftEmail" size="33" maxlength="256" value="<?php echo $emailAddress_l; ?>">
		          </td>
                <td align="right" valign="bottom">
                  <input type="button" name="leftSendBtn" value="Send" onClick="send_onclick( this );">&nbsp;
		          </td>
              </tr>
		        <tr>
                <td align="left" height="20">
			    	  Subject:
                </td>
                <td colspan="3" align="left">
			    	  <input type="text" name="leftSubject" size="43" maxlength="256">
    	        </td>
              </tr>
		        <tr>
                <td colspan="4" align="left" height="20">
			         <textarea cols="40" rows="6" name="leftMessage" id="leftMessage" onFocus="message_onfocus( this );">message</textarea>
			       </td>
              </tr>
            </table>
		    </td>
          </form>
		  </tr>
		</table>
    </td>
	 
    <td width="8%" align="center" bordercolor="#C0C0C0">
      <table width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" align="center">
        <tr>
          <td class="repeat"></td>
        </tr>
      </table>
    </td>

    <td width="46%" align="left">
      <table width="100%" height="100%" cellspacing="0" cellpadding="2" border="0" background="parchment.jpg" align="left">
	     <tr>
		  <td>
            <table width="100%" height="100%" cellspacing="0" cellpadding="2" border="0" background="parchment.jpg">
              <tr>
                <td colspan="4" valign="middle" height="32">
			         <font size="+2"><strong><?php echo strToUpper( $lastName_r ); ?></strong></font>
                </td>
              </tr>
              <tr>
                <td colspan="2" valign="top" height="20">
					   <font size="+1"><?php echo $firstName_r; ?>&nbsp;<?php echo $middleName_r; ?></font>
                </td>
              </tr>
              <tr>
                <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
              </tr>
              <tr>
                <td colspan="4" valign="top" height="20">
					   <font size="+1"><?php echo $address1_r; ?></font>
                </td>
              </tr>
				  <?php
				  if( $address2_r != "" )
				  {
				     echo "              <tr>";
                 echo "                <td colspan='4' valign='top' height='20'>";
					  echo "                  <font size='+1'>$address2_r</font>";
                 echo "                </td>";
                 echo "              </tr>";
				  }
				  ?>
				  <tr>
                <td valign="top" height="20" colspan="2">
					   <font size="+1"><?php echo $city_r; if( $city_r != "" ) echo ","; ?>&nbsp;<?php echo $state_r; ?>&nbsp;<?php echo $zip_r; ?></font>
                </td>
              </tr>
				  <?php
				  if( $country_r != "" )
				  {
				     echo "              <tr>";
                 echo "                <td colspan='4' valign='top' height='20'>";
					  echo "                  <font size='+1'>$country_r</font>";
                 echo "                </td>";
                 echo "              </tr>";
				  }
				  ?>
              <tr>
                <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
              </tr>
				  <tr>
                <td valign="top" height="20" width="5%">
					   Home:
                </td>
                <td valign="top" height="20" colspan="3">
					   <font size="+1"><?php echo $hphone_ac_r; ?>&nbsp;<?php echo $hphone_r; ?>&nbsp;<?php if( $hphone_ext_r != "" ) echo "ext: $hphone_ext_r"; else echo "&nbsp;"; ?></font>
                </td>
              </tr>
				  <tr>
                <td valign="top" height="20" width="5%">
					   Work:
                </td>
                <td valign="top" height="20" colspan="3">
					   <font size="+1"><?php echo $wphone_ac_r; ?>&nbsp;<?php echo $wphone_r; ?>&nbsp;<?php if( $wphone_ext_r != "" ) echo "ext: $wphone_ext_r"; else echo "&nbsp;"; ?></font>
                </td>
              </tr>
				  <tr>
                <td valign="top" height="20" width="5%">
					   Cell:
                </td>
                <td valign="top" height="20" colspan="3">
					   <font size="+1"><?php echo $cphone_ac_r; ?>&nbsp;<?php echo $cphone_r; ?></font>
                </td>
              </tr>
              <tr>
                <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
              </tr>
              <tr>
                <td valign="top" height="100%" colspan="4">
                  <?php echo $notes_r; ?>
                </td>
              </tr>
              <tr>
                <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
              </tr>
            </table>
		    </td>
        </tr>
		  <tr>
          <form action="PB_display.php?page=<?php echo $page ?>" method="post" name="rightForm" id="rightForm">
		    <td height="20">
            <table width="100%" cellspacing="0" cellpadding="2" border="0" background="parchment.jpg">
              <tr>
                <td align="left" valign="bottom">
				      E-mail:
                </td>
                <td colspan="2" align="left" height="20" valign="bottom">
			      	<input type="text" name="rightEmail" size="33" maxlength="256" value="<?php echo $emailAddress_r; ?>">
		          </td>
                <td align="right" valign="bottom">
                  <input type="button" name="rightSend" value="Send" onClick="send_onclick( this );">&nbsp;
		          </td>
              </tr>
		        <tr>
                <td align="left" height="20">
			    	  Subject:
                </td>
                <td colspan="3" align="left">
			    	  <input type="text" name="rightSubject" size="43" maxlength="256">
    	        </td>
              </tr>
		        <tr>
                <td colspan="4" align="left" height="20">
			         <textarea cols="40" rows="6" name="rightMessage" id="rightMessage" onFocus="message_onfocus( this );">message</textarea>
			       </td>
              </tr>
            </table>
		    </td>
          </form>
		  </tr>
		</table>
    </td>
  </tr>

  <tr bgcolor="#DCE9B1">	 
    <td colspan="3" bordercolor="#999999">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" align="left" bgcolor="#DCE9B1">
      <form name="controlForm" method="post" action="">
        <tr>
          <td height="8" colspan="5"></td>
        </tr>
        <tr height="25">
            <td width="12%" valign="middle" align="right">
            <a href="#" name="btn_edit_l" onClick="goEdit( this.name ); return true;">
              <img name="img_edit_l" src="Images/btn_edit_up.gif" width="80" height="32" border="0" alt="Edit left entry" align="middle" onMouseDown="imgReset( this, 'Images/btn_edit_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_edit_up.gif' )"  onMouseOut="imgReset( this, 'Images/btn_edit_up.gif' )">
	          </a>
          </td>
          <td width="16">&nbsp;</td>
          <td width="11%" valign="middle" align="left">
            <a href="#" name="btn_delete_l" onClick="goDelete( this.name ); return true;">
              <img name="img_delete_l" src="Images/btn_delete_up.gif" width="80" height="32" border="0" alt="Delete left entry" align="middle" onMouseDown="imgReset( this, 'Images/btn_delete_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_delete_up.gif' )"  onMouseOut="imgReset( this, 'Images/btn_delete_up.gif' )">
            </a>
          </td>
          <td width="24%" valign="middle" align="right">
            <a href="#" name="btn_prev" onClick="goPrev(  ); return true;">
              <img name="img_prev" src="Images/btn_prev_up.gif" width="80" height="32" border="0" alt="Go to previous entry" align="middle" onMouseDown="imgReset( this, 'Images/btn_prev_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_prev_up.gif' )"  onMouseOut="imgReset( this, 'Images/btn_prev_up.gif' )">
            </a>
          </td>
					
          <td width="6%" valign="middle" align="center">&nbsp;</td>
			 
          <td width="24%" valign="middle" align="left">
            <a href="#" name="btn_next" onClick="goNext( ); return true;">
              <img name="img_next" src="Images/btn_next_up.gif" width="80" height="32" border="0" alt="Go to next entry" align="middle" onMouseDown="imgReset( this, 'Images/btn_next_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_next_up.gif' )"  onMouseOut="imgReset( this, 'Images/btn_next_up.gif' )">
            </a>
          </td>
          <td width="11%" valign="middle" align="right">
            <a href="#" name="btn_edit_l" onClick="goDelete( this.name ); return true;">
              <img name="img_delete_r" src="Images/btn_delete_up.gif" width="80" height="32" border="0" alt="Delete right entry" align="middle" onMouseDown="imgReset( this, 'Images/btn_delete_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_delete_up.gif' )"  onMouseOut="imgReset( this, 'Images/btn_delete_up.gif' )">
            </a>
          </td>
          <td width="16">&nbsp;</td>
          <td width="12%" valign="middle" align="left">
            <a href="#" name="btn_edit_r" onClick="goEdit( this.name ); return true;">
              <img name="img_edit_r" src="Images/btn_edit_up.gif" width="80" height="32" border="0" alt="Edit right entry" align="middle" onMouseDown="imgReset( this, 'Images/btn_edit_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_edit_up.gif' )"  onMouseOut="imgReset( this, 'Images/btn_edit_up.gif' )">
            </a>
          </td>
        </tr>
        <tr bgcolor="#DCE9B1">
          <td height="8" colspan="5"></td>
        </tr>
      </form>
      </table>
    </td>
  </tr>
</table>
</body>
</html>
