<?php
session_start( );

// return spaces, dashes and single quotes to strings
function decodeEntry( $str )
{
   $str = str_replace( "&nbsp;"," ",  $str );
	$str = str_replace(  "&ndash;","-", $str );
	$str = str_replace(  "&quot;","'", $str );
	$str = stripslashes( $str );
   $str = trim( $str );
	
	return $str;
}

// retrieve passed variable and put page number to be edited in session variable
$pageToEdit = $_REQUEST[ 'page' ];
session_register( 'pageToEdit' );
$_SESSION[ 'pageToEdit' ] = $pageToEdit;

session_register( 'entryType' );
$entryType = $_SESSION[ 'entryType' ];

session_register( 'delimiter' );
$delimiter = $_SESSION[ 'delimiter' ];

// retrieve the field values from the corresponding page
if( ( $pageToEdit % 2 ) == 0 )
{
   // page is an even number, so it is the left page
   session_register( 'leftEntryLine' );
   $entryLine = $_SESSION[ 'leftEntryLine' ];
}

else
{
   // page is an odd number, so it is the right page
   session_register( 'rightEntryLine' );
   $entryLine = $_SESSION[ 'rightEntryLine' ];
}

// get the left form fields from the entry string
$lastName = decodeEntry( strtok( $entryLine, '~' ) );
$firstName = decodeEntry( strtok( '~' ) );
$middleName = decodeEntry( strtok( '~' ) );
$address1 = decodeEntry( strtok( '~' ) );
$address2 = decodeEntry( strtok( '~' ) );
$city = decodeEntry( strtok( '~' ) );
$state = decodeEntry( strtok( '~' ) );
$zip = decodeEntry( strtok( '~' ) );
$country = decodeEntry( strtok( '~' ) );
$hphone_ac = decodeEntry( strtok( '~' ) );
$hphone = decodeEntry( strtok( '~' ) );
$hphone_ext = decodeEntry( strtok( '~' ) );
$wphone_ac = decodeEntry( strtok( '~' ) );
$wphone = decodeEntry( strtok( '~' ) );
$wphone_ext = decodeEntry( strtok( '~' ) );
$cphone_ac = decodeEntry( strtok( '~' ) );
$cphone = decodeEntry( strtok( '~' ) );
$notes = decodeEntry( strtok( '~' ) );
$emailAddress = decodeEntry( strtok( '~' ) );
$type = decodeEntry( strtok( '~' ) );

$thisPage = $_SERVER[ 'PHP_SELF' ];
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Personal Diary - Edit Address Book Entry</title>
<link rel="stylesheet" type="text/css" href="PD.css"> 


<script type="text/javascript" language="JavaScript">
<!-- hide from scripts older browsers

<?php include "emailcheck.js"; ?>

var isChanged = false;

// set variable to indicate if any field has been changed
function check_onchange( element )
{
   var delimiterStr = "<?php echo $delimiter ?>";
 
   if( element.value.indexOf( delimiterStr ) >= 0 )
	{
	   alert( "Use of " + delimiterStr + " is illegal." );
		element.value = "";
		
		return true;
	}
	
   isChanged = true;
	
   return true;
}

// check for use of the tilde (~), used as a delimeter in stored data string
function reset_onclick( )
{
   isChanged = false;
}

// if email address field is not empty, check for valid address
function newEntryForm_onsubmit( formName )
{
   if( isChanged != true )
	{
      document.location.replace( "PD_display.php?page=0" );
		
		return false;
	}
	
	var eAddress = formName.emailAddress.value;
	
	if( eAddress == "" || eAddress == " " )
	{
	   return true;
	}

   if(  isEmailValid( formName, "emailAddress" ) == false )
   {
      return false;
   }
	
	 return true;
}

// change the button's image
function imgReset( button, newImage )
{
   button.src = newImage;

   return true;
}

// return to phone book if user chooses to cancel entry
function cancel_onclick( )
{
   document.location.replace( "PD_display.php?page=<?php echo $pageToEdit ?>" );
	
	return false;
}

// end hiding comment -->
</script>
</head>

<body bgcolor="#DCE9B1">
<form action="PD_saveEdit.php" method="post" name="newEntryForm" id="newEntryForm" onSubmit="return( newEntryForm_onsubmit( this ) ? true : false );">
<table bgcolor="#DCE9B1" width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" align="center" onSubmit="return ( checkFields( ) ? true : false );">
  <tr>
    <td valign="middle">
      <table width="50%" height="60%" cellspacing="0" cellpadding="2" border="1" align="center" bgcolor="#FFFFCC">
        <tr>
          <td>
            Type:
          </td>
          <td valign="top" height="20" colspan="2">
            <input type="radio" name="entryType" value="personal" <?php if( $type != 'business' ) echo "checked"; ?> >Personal&nbsp;<input type="radio" name="entryType" value="business"<?php if( $type == 'business' ) echo "checked"; ?> >Business
          </td>
        </tr>
        <tr>
          <td width="25%">
            First:
          </td>
          <td valign="middle" height="20" colspan="3">
            <input type="text" name="firstName" value="<?php echo $firstName ?>" size="45" maxlength="64" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td>
            Middle:
          </td>
          <td valign="top" height="20" colspan="3">
            <input type="text" name="middleName" value="<?php echo $middleName ?>" size="45" maxlength="64" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td>
            Last:
          </td>
          <td valign="top" height="20" colspan="3">
            <input type="text" name="lastName" value="<?php echo $lastName ?>" size="45" maxlength="64" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
        </tr>
        <tr>
          <td>
            Address:
          </td>
          <td valign="top" height="20" colspan="3">
            <input type="text" name="address1" value="<?php echo $address1 ?>" size="45" maxlength="64" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td>
            &nbsp;
          </td>
          <td valign="top" height="20" colspan="3">
            <input type="text" name="address2" value="<?php echo $address2 ?>" size="45" maxlength="64" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td>
            City:
          </td>
          <td valign="top" height="20" colspan="3">
            <input type="text" name="city" value="<?php echo $city ?>" size="45" maxlength="64" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td>
            State:
          </td>
          <td valign="top" height="20">
            <input type="text" name="state" value="<?php echo $state ?>" size="25" maxlength="64" onChange="check_onchange( this );">&nbsp;Zip:&nbsp;<input type="text" name="zip" value="<?php echo $zip ?>" size="10" maxlength="64" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td>
            Country:
          </td>
          <td valign="top" height="20">
            <input type="text" name="country" value="<?php echo $country ?>" size="45" maxlength="64" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
        </tr>
        <tr>
          <td>
            Home:
          </td>
          <td valign="top" height="20">
            <input type="text" name="hphone_ac" value="<?php echo $hphone_ac ?>" size="3" maxlength="5" onChange="check_onchange( this );"> <input type="text" name="hphone" value="<?php echo $hphone ?>" size="10" maxlength="10" onChange="check_onchange( this );"> Ext: <input type="text" name="hphone_ext" value="<?php echo $hphone_ext ?>" size="5" maxlength="7" onChange="check_onchange( this );" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td>
            Work:
          </td>
          <td valign="top" height="20">
            <input type="text" name="wphone_ac" value="<?php echo $wphone_ac ?>" size="3" maxlength="5" onChange="check_onchange( this );"> <input type="text" name="wphone" value="<?php echo $wphone ?>" size="10" maxlength="10" onChange="check_onchange( this );"> Ext: <input type="text" name="wphone_ext" value="<?php echo $wphone_ext ?>" size="5" maxlength="7" onChange="check_onchange( this );" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td>
            Cell:
          </td>
          <td valign="top" height="20">
            <input type="text" name="cphone_ac" value="<?php echo $cphone_ac ?>" size="3" maxlength="5" onChange="check_onchange( this );"> <input type="text" name="cphone" value="<?php echo $cphone ?>" size="10" maxlength="10" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td>
            E-mail:
          </td>
          <td valign="top" height="20" colspan="3">
            <input type="text" name="emailAddress" value="<?php echo $emailAddress ?>" size="45" maxlength="64" onChange="check_onchange( this );">
          </td>
        </tr>
        <tr>
          <td colspan="4" height="8" bgcolor="#DCE9B1"></td>
        </tr>
        <tr>
          <td align="left" valign="top" width="5%">
            Notes: 
          </td>
          <td valign="top" height="20" colspan="3">
              <textarea name="notes" cols="34" rows="5" onChange="check_onchange( this );"><?php echo $notes ?></textarea>
          </td>
        </tr>
      </table>
    </td>
  </tr>

  <tr bgcolor="#DCE9B1">	 
    <td colspan="3" bordercolor="#999999" height="10%">
      <table width="54%" height="10%" border="0" cellspacing="0" cellpadding="0" align="center">
        <tr height="25">
          <td width="1%">&nbsp;</td>
          <td width="33%" valign="middle" align="left">
			   <button class="btn-green" type="submit" name="submit" value="submit" width="80" height="32">
              <img name="img_save" src="Images/btn_save_up.gif" width="80" height="32" border="0" alt="Save new entry" align="middle" onMouseDown="imgReset( this, 'Images/btn_save_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_save_up.gif' )" onMouseOut="imgReset( this, 'Images/btn_save_up.gif' )">
				</button>
          </td>
          <td width="32%" valign="middle" align="center">
			   <button class="btn-green" type="reset" name="reset" value="reset" width="80" height="32" onClick="reset_onclick()">
              <img name="img_reset" src="Images/btn_reset_up.gif" width="80" height="32" border="0" alt="Reset page" align="middle" onMouseDown="imgReset( this, 'Images/btn_reset_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_reset_up.gif' )" onMouseOut="imgReset( this, 'Images/btn_reset_up.gif' )">
				</button>
          </td>
          <td width="33%" valign="middle" align="right">
			   <button class="btn-green" type="button" name="cancel" value="cancel" width="80" height="32" onClick="cancel_onclick()">
              <img name="img_cancel" src="Images/btn_cancel_up.gif" width="80" height="32" border="0" alt="Cancel" align="middle" onMouseDown="imgReset( this, 'Images/btn_cancel_down.gif' )" onMouseUp="imgReset( this, 'Images/btn_cancel_up.gif' )" onMouseOut="imgReset( this, 'Images/btn_cancel_up.gif' )">
				</button>
          </td>
          <td width="1%">&nbsp;</td>
        </tr>
      </table>
    </td>
  </tr>
</table>
</form>
</body>
</html>
